proc tabulate missing noseps data = ghpb08;
TITLE 'Table B4.  Premiums Paid';
TITLE2 'by type of insurance, type of plan, and type of insurance contract, 2008';
TITLE3 '(numbers in millions)';
class ent2 INS3 filingsize;
var TOT_PREM H_CONTRACT_PREM STOPLOSS_PREM OTHER_PREM;
FORMAT INS3 INS3F.;
LABEL TOT_PREM  ='Premium Paid ';
LABEL  H_CONTRACT_PREM ='Health';
LABEL STOPLOSS_PREM ='Stop-Loss';
LABEL  OTHER_PREM ='Other';
table all='Total Plans' filingsize=' ', 
(TOT_PREM H_CONTRACT_PREM STOPLOSS_PREM OTHER_PREM)*sum=' '*f=K12f., 
(all='Total' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';                                                                                                                             
RUN;  
